from django import forms
from .models import Club, Official
from datetime import date


class ClubForm(forms.ModelForm):
    username = forms.CharField(max_length=150)
    email = forms.EmailField()
    password = forms.CharField(widget=forms.PasswordInput)
    
    class Meta:
        model = Club
        exclude = ["user", "season", "status", "reg_year", "updated_at", "date_created"]
       
        
class ResubmitClubForm(forms.ModelForm):
    username = forms.CharField(max_length=150)
    email = forms.EmailField()
    password = forms.CharField(widget=forms.PasswordInput)
    
    class Meta:
        model = Club
        exclude = ["user", "season", "status", "reg_year", "updated_at", "date_created", "rejection_message"]
        

class OfficialForm(forms.ModelForm):
    class Meta:
        model = Official
        fields = [
            'name', 'designation', 'sex', 'is_coach',
             'coaching_certificate_obtained',
            'certificate_year', 'certificate_upload',
            'passport_photo'
        ]
        widgets = {
            
            'sex': forms.Select(choices=[
                ('Male', 'Male'),
                ('Female', 'Female'),
                ('Other', 'Other'),
            ]),
            'is_coach': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
        }

    def clean(self):
        cleaned_data = super().clean()
        is_coach = cleaned_data.get('is_coach', False)

        if is_coach:
            if not cleaned_data.get('coaching_certificate_obtained'):
                self.add_error('coaching_certificate_obtained', 'Required for coaches.')
            if not cleaned_data.get('certificate_year'):
                self.add_error('certificate_year', 'Required for coaches.')
            if not cleaned_data.get('certificate_upload'):
                self.add_error('certificate_upload', 'Upload required for coaches.')
